// Mifare ProDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Mifare Pro.h"
#include "Mifare ProDlg.h"

#include "umfh.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#pragma comment(lib,"umf.lib")

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About
CString Byte2BinaryStream(const BYTE val);
CString Byte2BinaryStream(const BYTE val)
{
    CString szBinary(_T(""));
    for(BYTE mask = 0x80; mask; mask >>= 1)
    {
        if( (val & mask) ) 
        {
            szBinary += _T("1");
        }
        else
        {
            szBinary += _T("0");
        }
    }

    return szBinary;
}

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMifareProDlg dialog

CMifareProDlg::CMifareProDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMifareProDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMifareProDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMifareProDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMifareProDlg)
	DDX_Control(pDX, IDC_LIST1, m_list);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMifareProDlg, CDialog)
	//{{AFX_MSG_MAP(CMifareProDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMifareProDlg message handlers

BOOL CMifareProDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMifareProDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMifareProDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMifareProDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//Reset
void CMifareProDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here
	m_list.ResetContent();

	unsigned char rlength,rbuffer[255]={0};
	unsigned char showrbuffer[255]={0};

	if(!fw_reset_mifarepro(icdev,&rlength,rbuffer))
	{
		m_list.AddString("fw_reset_mifarepro OK");

		hex_a(showrbuffer,rbuffer,2*rlength);
//		m_list.AddString((char *)showrbuffer);
		showMsg((char *)showrbuffer);
		return;
	}
	m_list.AddString("fw_reset_mifarepro Error");

}
// initial comm
void CMifareProDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	

	icdev=fw_init(100,115200);  //USB ӿ
	//icdev=fw_init(0,115200);    //
	if(icdev>0)
	{
		if(!fw_setcpu_mifarepro(icdev,0x0d))
		{
			//setcpu
			
		}
		
		unsigned long ncard;
		if(!fw_card(icdev,0,&ncard))
		{
			//find card success
		
		}
		MessageBox("Open port success");
		return;
		
	}

	AfxMessageBox("Open port failed");

}
void CMifareProDlg::showMsg(char *data)
{
	int datalen=strlen(data);
	int showtime=datalen/32+1;
	for(int i=0;i<showtime;i++)
	{
		char *tempbuf;
		tempbuf=(char *)malloc(32*sizeof(char));
		char *singshow;
		singshow=tempbuf;
		for(int j=0;j<32;j++)
		{
			*(tempbuf++)=*(data++);
		}
		m_list.AddString(singshow);

		free(singshow);

	}

}


//Write and Read

void CMifareProDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
	unsigned char sentBuffer[255];
	unsigned char realsentBuf[255];
	
	unsigned char relen;
	unsigned char reBuffer[255];
	unsigned char rtempBuffer[255];
	memset(sentBuffer,0,255);
	memset(realsentBuf,0,255);
	memset(reBuffer,0,255);
	memset(rtempBuffer,0,255);

	CString m_commandInfo;
	char * commandBuf;
	for(int i=0;i<5;i++)
	{

		m_commandInfo.ReleaseBuffer();

		switch(i)
		{
		case 0:
			m_commandInfo=_T("00A40000022F02");
			commandBuf="00A40000022F02";
			break;
		case 1:
			m_commandInfo=_T("00A4020002ef02");
			commandBuf="00A4020002ef02";
			break;
		case 2:
			m_commandInfo=_T("002000000412345678");
			commandBuf="002000000412345678";
			break;
		case 3:
			m_commandInfo=_T("00d600003c112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788112233445566778811223344");
			commandBuf="00d600003c112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788112233445566778811223344";
			break;
		case 4:
			m_commandInfo=_T("00b000003c");
			commandBuf="00b000003c";
			break;
		default:
			break;
		}
		
		int sentInfolen=strlen(m_commandInfo)/2;
		
		for(int j=0;j<2*sentInfolen;j++)
		{
			sentBuffer[j]=m_commandInfo.GetAt(j);
		}

		memset(realsentBuf,0,255);

		a_hex(realsentBuf,sentBuffer,sentInfolen);
		
		if(!fw_apdu_mifarepro(icdev,(unsigned char)sentInfolen,
			realsentBuf,&relen,reBuffer))
		{
			showMsg("Send :");
			showMsg(commandBuf);

			
			hex_a(rtempBuffer,reBuffer,2*relen);
			showMsg("Receive:");
			showMsg((char *)rtempBuffer);
			continue;
		}
		
		showMsg("Send command error!");
	}

}
